<?php
require 'db.php';
header('Content-Type: application/json');

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['section_code'])) {
    $section = trim($_POST['section_code']);

    $stmt = $conn->prepare("
        SELECT id, first_name, last_name, permit_number, classroom_completed
        FROM Students
        WHERE section_code = ?
        ORDER BY last_name, first_name
    ");
    $stmt->bind_param("s", $section);
    $stmt->execute();
    $result = $stmt->get_result();

    $students = [];
    while ($row = $result->fetch_assoc()) {
        $students[] = $row;
    }

    echo json_encode($students);
    $stmt->close();
} else {
    echo json_encode([]);
}

