<?php
require_once __DIR__ . '/includes/PHPMailer/PHPMailer.php';
require_once __DIR__ . '/includes/PHPMailer/SMTP.php';
require_once __DIR__ . '/includes/PHPMailer/Exception.php';

require_once __DIR__ . '/vendor/setasign/fpdf/fpdf.php';
require_once __DIR__ . '/vendor/autoload.php';

ini_set('display_errors','1');
ini_set('display_startup_errors','1');
error_reporting(E_ALL);

use setasign\Fpdi\Fpdi;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// ==== Form Data ====
$data = $_POST;
function inchesToPoints($inches) {
    return $inches * 72;
}

$raw_dob = $_POST['dob'] ?? '';
$dob = '';

if (!empty($raw_dob)) {
    $dob = date('m-d-Y', strtotime($raw_dob));
}

// ==== Start PDF Build ====
$dl14bPath = 'assets/dl-14b.pdf';
if (!is_file($dl14bPath)) {
    throw new RuntimeException('Template PDF not found: ' . $dl14bPath);
}

$pdf = new Fpdi('P', 'pt', 'Letter');
$pdf->AddPage();
$pdf->setSourceFile($dl14bPath);
$templateId = $pdf->importPage(1);
$pdf->useTemplate($templateId, 0, 0, 612, 792);

$pdf->SetFont('Arial');
$pdf->SetTextColor(0, 0, 0);
$pdf->SetFontSize(10);

// === Fill Fields ===
$pdf->SetXY(inchesToPoints(1.04), inchesToPoints(1.77)); $pdf->Write(0, $data['last_name'] ?? '');
$pdf->SetXY(inchesToPoints(3.81), inchesToPoints(1.77)); $pdf->Write(0, $data['first_name'] ?? '');
$pdf->SetXY(inchesToPoints(6.75), inchesToPoints(1.77)); $pdf->Write(0, $data['middle_name'] ?? '');
// ... keep your other SetXY/Write calls, but defensively use ?? '' on every $data[...] ...

// Add page 2 only if the template has it
try {
    $pageCount = $pdf->setSourceFile($dl14bPath); // returns page count in newer FPDI
} catch (Throwable $e) {
    // some FPDI versions require re-calling setSourceFile; we already have it above,
    // so just assume at least 1 page if this throws — the first page is already used
    $pageCount = 1;
}

if ($pageCount >= 2) {
    $pdf->AddPage();
    $page2 = $pdf->importPage(2);
    $pdf->useTemplate($page2, 0, 0, 612, 792);
}

// ==== Build output filename ====
$filename   = 'DL14B_' . time() . '.pdf';
$contracts  = __DIR__ . '/contracts';
$outputPath = $contracts . '/' . $filename;

// Ensure contracts dir exists and is writable
if (!is_dir($contracts)) {
    if (!mkdir($contracts, 0755, true) && !is_dir($contracts)) {
        throw new RuntimeException('Failed to create contracts directory: ' . $contracts);
    }
}

// Save PDF to disk
$pdf->Output('F', $outputPath);

// Verify the PDF is really there and readable
if (!is_file($outputPath) || !is_readable($outputPath) || filesize($outputPath) < 100) {
    error_log("PDF write failed or too small: $outputPath (exists=" . (int)file_exists($outputPath) . ", size=" . @filesize($outputPath) . ")");
    echo "<p>We received your form, but couldn't create the attachment. We'll follow up shortly.</p>";
    exit;
}


// ==== Email to Admin (final) ====
$LOG_DIR = __DIR__ . '/logs';
if (!is_dir($LOG_DIR)) { mkdir($LOG_DIR, 0755, true); }
$SMTP_LOG = $LOG_DIR . '/smtp.log';
@file_put_contents($SMTP_LOG, "=== CLEAN 465 RUN " . date('c') . " ===\n");

$mail = new PHPMailer(true);
$mail->isSMTP();

// IMPORTANT: use the cert name; do NOT wrap in gethostbyname()
$mail->Host       = 'ocean.squidix.net';
$mail->SMTPAuth   = true;
$mail->Username   = 'no-reply@tandddrivingacademy.com';
$mail->Password   = '!ResetPassword1!';

// 465 + SMTPS (no STARTTLS negotiation)
$mail->Port       = 465;
$mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
$mail->SMTPAutoTLS = true;      // harmless here
$mail->Timeout    = 8;
$mail->Helo       = 'bookings.tandddrivingacademy.com';

$mail->setFrom('no-reply@tandddrivingacademy.com', 'T&D Driving Academy');
$mail->addAddress('no-reply@tandddrivingacademy.com');
$mail->addAttachment($outputPath);

$mail->isHTML(true);
$mail->Subject = 'New DL-14B Application Submitted';
$mail->Body    = 'A new DL-14B form has been submitted. See attached.';

// Keep transcript briefly, then set to 0
$mail->SMTPDebug = 2;
$mail->Debugoutput = function($s,$l) use ($SMTP_LOG){ file_put_contents($SMTP_LOG, "[$l] $s\n", FILE_APPEND); };

file_put_contents($SMTP_LOG, "HIT 465 BLOCK\n", FILE_APPEND);

$mail->send();
header('Location: confirmation.php');
exit;
?>




