<?php
require 'db.php';

header('Content-Type: application/json');

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['instructor_id'])) {
    $instructor_id = intval($_POST['instructor_id']);

    $stmt = $conn->prepare("
        SELECT id, first_name, last_name, email, license_number, license_expiration 
        FROM Instructors 
        WHERE id = ?
    ");
    $stmt->bind_param("i", $instructor_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && $row = $result->fetch_assoc()) {
        echo json_encode($row);
    } else {
        echo json_encode([]);
    }

    $stmt->close();
} else {
    echo json_encode([]);
}
?>
