<?php
require 'db.php';

header('Content-Type: application/json'); // Explicitly return JSON

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['student_id'])) {
    $student_id = intval($_POST['student_id']);

    // Log the request (safe to keep)
    file_put_contents('cert-debug-log.txt', "✅ Hit with student_id: {$student_id}\n", FILE_APPEND);

    $stmt = $conn->prepare("
        SELECT 
            permit_number, 
            permit_received_at, 
            de964_number, 
            ade1317_number, 
            duplicate_de964, 
            duplicate_ade1317,
            classroom_completed
        FROM Students 
        WHERE id = ?
    ");
    $stmt->bind_param("i", $student_id);
    $stmt->execute();
    $result = $stmt->get_result();

    // Return an empty object if no record found
    if ($result && $row = $result->fetch_assoc()) {
        echo json_encode($row);
    } else {
        echo json_encode([]);
    }

    $stmt->close();
} else {
    // Return empty JSON on invalid request
    echo json_encode([]);
}
?>





