<?php
// includes/send_email.php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// If you don't use Composer, require the PHPMailer classes directly:
require_once __DIR__ . '/PHPMailer/PHPMailer.php';
require_once __DIR__ . '/PHPMailer/SMTP.php';
require_once __DIR__ . '/PHPMailer/Exception.php';

// ----- Defaults for T&D (override per-call for TPST) -----
const DEFAULT_SMTP_HOST = 'ocean.squidix.net';
const DEFAULT_SMTP_PORT = 465; // SMTPS
const DEFAULT_SMTP_USER = 'no-reply@tandddrivingacademy.com';
const DEFAULT_SMTP_PASS = '!ResetPassword1!'; // <-- put the current password here
const DEFAULT_FROM_ADDR = 'no-reply@tandddrivingacademy.com';
const DEFAULT_FROM_NAME = 'T&D Driving Academy';

function make_mailer(
    string $fromAddr = DEFAULT_FROM_ADDR,
    string $fromName = DEFAULT_FROM_NAME,
    ?string $smtpUser = null,
    ?string $smtpPass = null,
    string $smtpHost = DEFAULT_SMTP_HOST,
    int $smtpPort = DEFAULT_SMTP_PORT
): PHPMailer {
    $m = new PHPMailer(true);
    $m->isSMTP();
    $m->Host        = $smtpHost;
    $m->SMTPAuth    = true;
    $m->Username    = $smtpUser ?? DEFAULT_SMTP_USER;
    $m->Password    = $smtpPass ?? DEFAULT_SMTP_PASS;
    $m->Port        = $smtpPort;
    $m->SMTPSecure  = PHPMailer::ENCRYPTION_SMTPS; // 465
    $m->SMTPAutoTLS = true;
    $m->Timeout     = 8;
    $m->CharSet     = 'UTF-8';
    // Optional nicety (HELO string)
    $m->Helo        = $_SERVER['HTTP_HOST'] ?? 'localhost';
    $m->setFrom($fromAddr, $fromName);
    // Turn off verbose debug in production
    $m->SMTPDebug   = 0;
    return $m;
}

/**
 * send_email — wraps PHPMailer for your handlers
 *
 * @param string $toEmail
 * @param string $toName
 * @param string $subject
 * @param string $htmlBody
 * @param array  $attachments file paths (optional)
 * @param array  $opts keys: from, from_name, smtp_user, smtp_pass, smtp_host, smtp_port, reply_to
 * @return bool
 * @throws \Throwable bubbles up so caller can catch and show a friendly message
 */
function send_email(
    string $toEmail,
    string $toName,
    string $subject,
    string $htmlBody,
    array $attachments = [],
    array $opts = []
): bool {
    if (!filter_var($toEmail, FILTER_VALIDATE_EMAIL)) {
        throw new Exception("Invalid recipient email: {$toEmail}");
    }
    if ($subject === '' || $htmlBody === '') {
        throw new Exception("Empty subject/body.");
    }

    $from      = $opts['from']       ?? DEFAULT_FROM_ADDR;
    $fromName  = $opts['from_name']  ?? DEFAULT_FROM_NAME;
    $smtpUser  = $opts['smtp_user']  ?? null; // default inside make_mailer
    $smtpPass  = $opts['smtp_pass']  ?? null;
    $smtpHost  = $opts['smtp_host']  ?? DEFAULT_SMTP_HOST;
    $smtpPort  = isset($opts['smtp_port']) ? (int)$opts['smtp_port'] : DEFAULT_SMTP_PORT;
    $replyTo   = $opts['reply_to']   ?? null;

    $mail = make_mailer($from, $fromName, $smtpUser, $smtpPass, $smtpHost, $smtpPort);

    // Helpful warning if From domain and SMTP user domain don’t match
    $fromDomain = substr(strrchr($from, "@"), 1) ?: '';
    $userDomain = substr(strrchr(($smtpUser ?? DEFAULT_SMTP_USER), "@"), 1) ?: '';
    if ($fromDomain && $userDomain && strcasecmp($fromDomain, $userDomain) !== 0) {
        // Not fatal, but many hosts will reject or rewrite
        error_log("send_email warning: From domain ($fromDomain) != SMTP user domain ($userDomain)");
    }

    if ($replyTo) {
        $mail->addReplyTo($replyTo);
    }

    $mail->addAddress($toEmail, $toName ?: $toEmail);

    foreach ($attachments as $path) {
        if (is_file($path) && is_readable($path)) {
            $mail->addAttachment($path);
        } else {
            error_log("send_email: skipping missing/unreadable attachment $path");
        }
    }

    $mail->isHTML(true);
    $mail->Subject = $subject;
    $mail->Body    = $htmlBody;

    return $mail->send();
}


