document.addEventListener("DOMContentLoaded", function () {
    const input = document.getElementById("student-search");
    const suggestions = document.getElementById("suggestions");

    input.addEventListener("input", function () {
        const query = input.value.trim();

        if (query.length === 0) {
            suggestions.innerHTML = "";
            suggestions.style.display = "none";
            return;
        }

        fetch("admin-drive-booking-search.php", {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: "query=" + encodeURIComponent(query)
        })
        .then(response => response.json())
        .then(data => {
            suggestions.innerHTML = "";
            if (data.length > 0) {
                data.forEach(student => {
                    const div = document.createElement("div");
                    div.classList.add("suggestion");
                    div.textContent = `${student.last_name}, ${student.first_name} (${student.email})`;
                    div.dataset.studentId = student.id;

                    div.addEventListener("click", () => {
                        input.value = `${student.last_name}, ${student.first_name}`;
                        document.getElementById("student_id").value = student.id;
                        suggestions.innerHTML = "";
                        suggestions.style.display = "none";
                    });

                    suggestions.appendChild(div);
                });
                suggestions.style.display = "block";
            } else {
                suggestions.style.display = "none";
            }
        })
        .catch(err => console.error("Search error:", err));
    });
});
