document.addEventListener("DOMContentLoaded", function () {
    const input = document.getElementById("student_search");
    const hiddenId = document.getElementById("student_id");
    const suggestions = document.getElementById("suggestions");
    const historyBox = document.getElementById("lesson-history");

    input.addEventListener("input", function () {
        const query = input.value.trim();
        if (query.length < 2) {
            suggestions.innerHTML = "";
            suggestions.style.display = "none";
            return;
        }

        fetch("log-drive-search.php?term=" + encodeURIComponent(query))
            .then(res => res.json())
            .then(data => {
                suggestions.innerHTML = "";
                if (data.length > 0) {
                    data.forEach(student => {
                        const item = document.createElement("div");
                        item.textContent = student.name;
                        item.style.padding = "8px";
                        item.style.cursor = "pointer";
                        item.style.borderBottom = "1px solid #ccc";

                        item.addEventListener("click", () => {
                            input.value = student.name;
                            hiddenId.value = student.id;
                            suggestions.innerHTML = "";
                            suggestions.style.display = "none";

                            // Fetch lesson history
                            fetch(`fetch-lesson-history.php?student_id=${student.id}`)
                                .then(res => res.json())
                                .then(data => {
                                    if (!data || !Array.isArray(data.lessons)) {
                                        historyBox.innerHTML = "<p>No history available.</p>";
                                        return;
                                    }

                                    const total = data.total_btw ?? 0;
                                    let html = `<h3>Completed Lessons</h3>`;
                                    html += `<p><strong>Total BTW Minutes:</strong> ${total} / 385</p>`;

                                    if (data.lessons.length === 0) {
                                        html += "<p>No completed lessons yet.</p>";
                                    } else {
                                        html += `<table><thead><tr><th>Lesson</th><th>Times Covered</th></tr></thead><tbody>`;
                                        data.lessons.forEach(entry => {
                                            html += `<tr><td>${entry.label}</td><td>${entry.times_covered}</td></tr>`;
                                        });
                                        html += `</tbody></table>`;
                                    }

                                    historyBox.innerHTML = html;
                                })
                                .catch(err => {
                                    console.error("Lesson history fetch failed:", err);
                                    historyBox.innerHTML = "<p>Error loading lesson history.</p>";
                                });
                        });

                        suggestions.appendChild(item);
                    });
                    suggestions.style.display = "block";
                } else {
                    suggestions.style.display = "none";
                }
            })
            .catch(err => {
                console.error("Student search error:", err);
                suggestions.style.display = "none";
            });
    });

    document.addEventListener("click", function (e) {
        if (!suggestions.contains(e.target) && e.target !== input) {
            suggestions.style.display = "none";
        }
    });
});


