// update-certificate-lookup.js
document.addEventListener("DOMContentLoaded", function () {
    const input = document.getElementById("studentSearch");
    const suggestionsBox = document.getElementById("suggestions");
    const hiddenInput = document.getElementById("studentId");

    if (!input || !suggestionsBox || !hiddenInput) return;

    input.addEventListener("input", function () {
        const query = input.value.trim();
        if (query.length < 2) {
            suggestionsBox.innerHTML = "";
            suggestionsBox.style.display = "none";
            return;
        }

        fetch("update-certificate-search.php", {
            method: "POST",
            headers: {
                "Content-Type": "application/x-www-form-urlencoded",
                "X-Requested-With": "XMLHttpRequest"
            },
            body: "search=" + encodeURIComponent(query)
        })
        .then(response => response.json())
        .then(data => {
            suggestionsBox.innerHTML = "";

            if (Array.isArray(data) && data.length > 0) {
                suggestionsBox.style.display = "block";

                data.forEach(student => {
                    const item = document.createElement("div");
                    item.classList.add("suggestion-item");
                    item.textContent = `${student.first_name} ${student.last_name}`;
                    item.dataset.studentId = student.id;

                    item.addEventListener("click", () => {
    input.value = `${student.first_name} ${student.last_name}`;
    hiddenInput.value = student.id;
    suggestionsBox.innerHTML = "";

    // Fetch and populate the form fields with existing certificate data
    fetch("get-student-certificate.php", {
        method: "POST",
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "X-Requested-With": "XMLHttpRequest"
        },
        body: "student_id=" + encodeURIComponent(student.id)
    })
    .then(response => response.json())
    .then(data => {
        document.getElementById("permit_number").value = data.permit_number || '';
        document.getElementById("permit_received_at").value = data.permit_received_at || '';
        document.getElementById("de964_number").value = data.de964_number || '';
        document.getElementById("ade1317_number").value = data.ade1317_number || '';
        document.getElementById("duplicate_de964").value = data.duplicate_de964 || '';
        document.getElementById("duplicate_ade1317").value = data.duplicate_ade1317 || '';
        document.getElementById("classroom_completed").value = data.classroom_completed !== undefined ? data.classroom_completed : '0';
    })
    .catch(error => {
        console.error("Error fetching certificate data:", error);
    });
});

            suggestionsBox.appendChild(item);
                });
            } else {
                suggestionsBox.style.display = "block";
                const noResult = document.createElement("div");
                noResult.classList.add("suggestion-item");
                noResult.textContent = "No matches found.";
                suggestionsBox.appendChild(noResult);
            }
        })
        .catch(err => {
            console.error("Update Cert Suggestion Error:", err);
        });
    });
});

