document.addEventListener("DOMContentLoaded", function () {
    const input = document.getElementById("instructorSearch");
    const suggestionsBox = document.getElementById("instructorSuggestions");
    const hiddenInput = document.getElementById("instructorId");

    input.addEventListener("input", function () {
        const query = input.value.trim();
        if (query.length < 2) {
            suggestionsBox.innerHTML = "";
            suggestionsBox.style.display = "none";
            return;
        }

        fetch("lookup-instructor.php", {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: "query=" + encodeURIComponent(query)
        })
        .then(res => res.json())
        .then(data => {
            suggestionsBox.innerHTML = "";
            if (data.length === 0) {
                suggestionsBox.style.display = "none";
                return;
            }

            data.forEach(instructor => {
                const div = document.createElement("div");
                div.textContent = `${instructor.last_name}, ${instructor.first_name}`;
                div.style.padding = "6px";
                div.style.cursor = "pointer";

                div.addEventListener("click", () => {
                    input.value = `${instructor.last_name}, ${instructor.first_name}`;
                    hiddenInput.value = instructor.id;
                    suggestionsBox.innerHTML = "";
                    suggestionsBox.style.display = "none";

                    // Fetch and populate form
                    fetch("get-instructor-data.php", {
                        method: "POST",
                        headers: { "Content-Type": "application/x-www-form-urlencoded" },
                        body: "instructor_id=" + instructor.id
                    })
                    .then(res => res.json())
                    .then(data => {
                        document.getElementById("first_name").value = data.first_name || "";
                        document.getElementById("last_name").value = data.last_name || "";
                        document.getElementById("email").value = data.email || "";
                        document.getElementById("license_number").value = data.license_number || "";
                        document.getElementById("license_expiration").value = data.license_expiration || "";
                    });
                });

                suggestionsBox.appendChild(div);
            });

            suggestionsBox.style.display = "block";
        });
    });

    document.addEventListener("click", (e) => {
        if (!suggestionsBox.contains(e.target) && e.target !== input) {
            suggestionsBox.style.display = "none";
        }
    });
});
