<?php
session_start();
require 'db.php';
require 'includes/PHPMailer/PHPMailer.php';
require 'includes/PHPMailer/SMTP.php';
require 'includes/PHPMailer/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$success = "";
$error = "";
// Set the 'minutes' column to match 'btw_minutes' for consistency

if (!isset($_SESSION['instructor_id'])) {
    header("Location: instructor-login.php");
    exit();
}

$instructor_id = $_SESSION['instructor_id'];
echo "<p style='color: white; font-weight: bold; margin-bottom: 20px;'>Logged in as instructor ID: $instructor_id</p>";


if ($_SERVER["REQUEST_METHOD"] === "POST")
{
    $student_id = $_POST['student_id'] ?? null;
    $btw_minutes = isset($_POST['btw_minutes']) ? intval($_POST['btw_minutes']) : 0;
    $ob_minutes  = isset($_POST['ob_minutes']) ? intval($_POST['ob_minutes']) : 0;
    $minutes     = $btw_minutes; // used for overall progress tracking
    $drive_date = $_POST['date'] ?? null;
    $scheduled_time = $_POST['scheduled_time'] ?? null;
    $lesson_group = isset($_POST['lesson_group']) ? trim($_POST['lesson_group']) : null;
    $lesson_status = isset($_POST['lesson_status']) ? trim($_POST['lesson_status']) : 'I';

$valid_statuses = ['I', 'F', 'P'];
$minutes = $btw_minutes; // use this for the 'minutes' column

if (!in_array($lesson_status, $valid_statuses)) {
    die("Invalid lesson status.");
}

    {
        // Convert lesson_group code (e.g., 'lesson_3') to its numeric ID
        $lesson_group_id = null;
        $lookup = $conn->prepare("SELECT id FROM lesson_groups WHERE code = ?");
        $lookup->bind_param("s", $lesson_group);
        $lookup->execute();
        $lookup->bind_result($lesson_group_id);
        $lookup->fetch();
        $lookup->close();
        
        if (!$lesson_group_id || !$lesson_group) {
            die("Invalid lesson group selection.");
        }

        
        if (!$lesson_group_id || !$lesson_group) {
    die("Missing or invalid lesson group. Log aborted.");
}

// Check total instruction minutes for this student on this date
$limit_check = $conn->prepare("
    SELECT 
        SUM(btw_minutes) AS total_btw,
        SUM(ob_minutes) AS total_ob,
        SUM(minutes) AS total_any
    FROM DriveSchedule
    WHERE student_id = ? AND drive_date = ?
");
$limit_check->bind_param("is", $student_id, $drive_date);
$limit_check->execute();
$limit_result = $limit_check->get_result()->fetch_assoc();
$limit_check->close();

// Proposed totals
$new_total_btw = intval($limit_result['total_btw']) + $btw_minutes;
$new_total_all = intval($limit_result['total_any']) + $btw_minutes + $ob_minutes;

// Validation
if ($new_total_btw > 120) {
echo "<div style='
    background: #ffe6e6;
    color: #a33;
    padding: 20px;
    font-family: Arial, sans-serif;
    border: 1px solid #a33;
    border-radius: 6px;
    max-width: 600px;
    margin: 40px auto;
    text-align: center;
'>
    <h3>Logging Denied</h3>
    <p><strong>Reason:</strong> Student would exceed the 2-hour Behind-the-Wheel limit for this day.</p>
    <p>Please double-check the selected date or adjust the minutes.</p>
    <div style='margin-top: 20px;'>
        <a href='instructor-dashboard.php' style='
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin-right: 10px;
        '>Return to Dashboard</a>
        <a href='log-drive.php' style='
            padding: 10px 20px;
            background-color: #6c757d;
            color: white;
            text-decoration: none;
            border-radius: 5px;
        '>Try Again</a>
    </div>
</div>";
exit;

}

if ($new_total_all > 300) {
    die("Logging denied: Student would exceed the 5-hour total instruction limit for this day.");
}
        // Validate drive ownership and date
        $ownership_check = $conn->prepare("
            SELECT bd.id 
            FROM BookedDrives bd
            JOIN InstructorAvailability ia ON bd.slot_id = ia.id
            WHERE bd.student_id = ? 
              AND ia.instructor_id = ? 
              AND ia.available_date = ?
              AND ia.start_time = ?
              AND CONCAT(ia.available_date, ' ', ia.start_time) <= NOW()
        ");
        $ownership_check->bind_param("iiss", $student_id, $instructor_id, $drive_date, $scheduled_time);
        $ownership_check->execute();
        $ownership_check->store_result();
        
        if ($ownership_check->num_rows === 0) {
            $ownership_check->close();
            die("<div style='color:red; font-weight:bold;'>Unauthorized: You can only log drives for your own past students and scheduled slots.</div>");
        }
        $ownership_check->close();

        // Insert using the new lesson_group_id
        $stmt = $conn->prepare("INSERT INTO DriveSchedule 
    (student_id, instructor_id, scheduled_time, minutes, drive_date, lesson_group_id, lesson_status, btw_minutes, ob_minutes) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("iiiisisii", $student_id, $instructor_id, $scheduled_time, $minutes, $drive_date, $lesson_group_id, $lesson_status, $btw_minutes, $ob_minutes);

        $stmt->execute();

        if ($stmt->execute()) {
            $success = "Drive time logged successfully.";

            $email_stmt = $conn->prepare("SELECT email, first_name, last_name FROM Students WHERE id = ?");
            $email_stmt->bind_param("i", $student_id);
            $email_stmt->execute();
            $result = $email_stmt->get_result();
            $student = $result->fetch_assoc();

            if ($student) {
                $mail = new PHPMailer(true);
                try {
                    $mail->isSMTP();
                    $mail->Host = 'mail.tandddrivingacademy.com';
                    $mail->SMTPAuth = true;
                    $mail->Username = 'info@tandddrivingacademy.com';
                    $mail->Password = '!DriverightTX!';
                    $mail->SMTPSecure = 'ssl';
                    $mail->Port = 465;

                    $mail->setFrom('info@tandddrivingacademy.com', 'T&D Driving Academy');
                    $mail->addAddress($student['email'], $student['first_name'] . ' ' . $student['last_name']);

                    $mail->isHTML(true);
                    $mail->Subject = 'Drive Time Logged';
                    $mail->Body = "Dear {$student['first_name']} {$student['last_name']},<br><br>Your drive time of {$minutes} minutes on {$drive_date} at {$scheduled_time} has been logged.<br><br>Thank you,<br>T&D Driving Academy";

                    $mail->send();
                } catch (Exception $e) {
                    error_log("Email could not be sent. Mailer Error: {$mail->ErrorInfo}");
                }
            }
        } else {
            $error = "Failed to log drive.";
        }
        $stmt->close();
    }
}
?>
<?php 
    $lesson_groups = [];
    $result = $conn->query("SELECT code, label FROM lesson_groups ORDER BY id ASC");
    while ($row = $result->fetch_assoc()) {
    $lesson_groups[$row['code']] = $row['label'];
    }
    ?>
    
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Log Drive Time</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: url('hotrod-1.jpg') no-repeat center center fixed;
            margin: 0;
            padding: 0;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-direction: column;
        }
        h2 {
            color: white;
            margin-top: 40px;
            text-shadow: 1px 1px 2px black;
            font-size: 28px;
        }
        .success {
            color: green;
            font-weight: bold;
            margin-bottom: 10px;
        }
        .error {
            color: red;
            font-weight: bold;
            margin-bottom: 10px;
        }
        .input-wrapper {
            background: rgba(255, 255, 255, 0.9);
            padding: 25px 30px;
            border-radius: 15px;
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
            margin-top: 20px;
            border: 1px solid #ccc;
        }
        
        .input-wrapper label {
            font-weight: bold;
            display: block;
            margin-top: 15px;
            margin-bottom: 5px;
            color: #333;
        }
        
        .input-wrapper input,
        .input-wrapper select {
            width: 100%;
            padding: 10px;
            border-radius: 6px;
            border: 1px solid #aaa;
            margin-bottom: 10px;
            font-size: 14px;
        }
        
        .input-wrapper button,
        .input-wrapper input[type="submit"] {
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 6px;
            padding: 10px 20px;
            margin-top: 10px;
            cursor: pointer;
        }
        
        .input-wrapper button:hover,
        .input-wrapper input[type="submit"]:hover {
            background-color: #0056b3;
        }

        form {
            max-width: 400px;
            margin-top: 20px;
        }
        input, select {
            width: 100%;
            margin: 8px 0;
            padding: 10px;
        }
        button {
            padding: 10px;
            margin: 5px 5px 0 0;
        }
        .container-flex {
            display: flex;
            gap: 40px;
            align-items: flex-start;
        }
        .form-container {
            flex: 1;
            max-width: 400px;
        }
        .lesson-history {
            flex: 1;
            border: 1px solid #ccc;
            padding: 15px;
            max-height: 400px;
            overflow-y: auto;
        }
        .lesson-history table {
            width: 100%;
            border-collapse: collapse;
        }
        .lesson-history th, .lesson-history td {
            padding: 8px;
            border: 1px solid #ccc;
            text-align: left;
        }
        .lesson-history h3 {
            margin-top: 0;
        }
        
        .lesson-history {
            flex: 1;
            border: 1px solid #ccc;
            padding: 15px;
            max-height: 400px;
            overflow-y: auto;
            background: #fdfdfd;
            border-radius: 12px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        input, select {
            width: 100%;
            margin: 8px 0;
            padding: 10px;
            background-color: #f0f0f0; /* light gray */
            border: 1px solid #ccc;
            border-radius: 4px;
            color: #000; /* text stays readable */
}


    </style>
</head>
<body>

<h2>Log Student Drive Time</h2>

<?php if ($success): ?>
    <p class="success"><?php echo $success; ?></p>
    <form method="get" action="log-drive.php">
    <button type="submit" onclick="localStorage.removeItem('selectedStudent')">Log Another Drive</button>
        <a href="instructor-dashboard.php"><button type="button">Return to Dashboard</button></a>
    </form>
<?php elseif ($error): ?>
    <p class="error"><?php echo $error; ?></p>
    <form method="get" action="log-drive.php">
        <button type="submit">Try Again</button>
        <a href="instructor-dashboard.php"><button type="button">Return to Dashboard</button></a>
    </form>
    
<?php else: ?>

<?php

$student_id = isset($_POST['student_id']) ? intval($_POST['student_id']) : 0;
$incomplete_lessons = [];

$stmt = $conn->prepare("
    SELECT lg.code, lg.label
    FROM DriveSchedule ds
    INNER JOIN lesson_groups lg ON ds.lesson_group_id = lg.id
    WHERE ds.student_id = ? AND ds.lesson_status IN ('I', 'F')
");
$stmt->bind_param("i", $student_id);
$stmt->execute();
$result = $stmt->get_result();

while ($row = $result->fetch_assoc()) {
    $incomplete_lessons[] = $row['code'];
}

if (empty($incomplete_lessons)) {
    // fallback to all lesson codes if none are incomplete yet
    $incomplete_lessons = array_keys($lesson_groups);
}

?>
<?php
$date_value = isset($_POST['date']) ? htmlspecialchars($_POST['date']) : '';
$time_value = isset($_POST['scheduled_time']) ? htmlspecialchars($_POST['scheduled_time']) : '';
?>
    <div style="text-align: center; margin-top: 30px;">
    <a href="instructor-dashboard.php" 
       style="display: inline-block; padding: 12px 24px; background-color: #3498db; color: white; 
              text-decoration: none; font-weight: bold; border-radius: 8px; 
              box-shadow: 0 4px 6px rgba(0,0,0,0.2); transition: background-color 0.3s;">
        Back to Instructor Dashboard
    </a>
    </div>
    <div class="container-flex">
    <div class="form-container">
        <form method="post" id="logDriveForm">
            <div class="input-wrapper">
            <!-- ... your form fields remain unchanged ... -->
            <!-- Just make sure student_id select box has id="student_id" -->
            <!-- Include both BTW and OB fields here (we'll update this next) -->

            <label for="student_search">Student:</label>
            <input type="text" id="student_search" placeholder="Type student name..." autocomplete="off">
            <input type="hidden" name="student_id" id="student_id">
                <div id="suggestions"></div>

            <?php if (!empty($_POST['student_id'])): ?>
                <input type="hidden" name="student_id" value="<?= htmlspecialchars($_POST['student_id']) ?>">
            <?php endif; ?>

            <label for="btw_minutes">Behind-the-Wheel Minutes:</label>
            <input type="number" name="btw_minutes" id="btw_minutes" min="0" max="120" step="5" placeholder="e.g., 40">

            <label for="ob_minutes">Observation Minutes:</label>
            <input type="number" name="ob_minutes" id="ob_minutes" min="0" max="120" step="5" placeholder="e.g., 80">

            <label for="lesson_group">Lesson Group Covered:</label>
            <select name="lesson_group" id="lesson_group" required>
                <option value="">-- Select a Lesson Group --</option>
            </select>

            <!-- Lesson options will be populated dynamically -->

            <label for="lesson_status">Result:</label>
            <select name="lesson_status" id="lesson_status" required>
                <option value="">-- Select Status --</option>
                <option value="P">Pass</option>
                <option value="F">Fail</option>
            </select>

            <label for="date">Drive Date:</label>
            <input type="date" name="date" value="<?= $date_value ?>" required>

            <label for="scheduled_time">Scheduled Time:</label>
            <input type="time" name="scheduled_time" value="<?= $time_value ?>" required>

            <input type="submit" value="Log Drive Time" id="submitBtn">
            </div> <!-- close .input-wrapper -->
        </form>
    </div> <!-- close .form-container -->
</div> <!-- close .container-flex -->
<div class="lesson-history" id="lesson-history">
    <h3>Completed Lessons</h3>
    <p>Select a student to view history...</p>
</div>
<?php endif; ?>
<script src="js/log-drive-search.js"></script>
<script>
    const lessonGroups = <?php echo json_encode($lesson_groups); ?>;

    const lessonSelect = document.getElementById('lesson_group');
    if (lessonSelect && lessonGroups) {
        Object.entries(lessonGroups).forEach(([code, label]) => {
            const option = document.createElement('option');
            option.value = code;
            option.textContent = label;
            lessonSelect.appendChild(option);
        });
    }
</script>
</body>
</html>



