<?php
session_start();

// Database connection
$conn = new mysqli("localhost", "tandddri_admin", "!S0ngw3av3r1!", "tandddri_Students");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$instructor_id = $_SESSION['instructor_id'] ?? null;
$success = "";
$error = "";

// Handle redirect success message
if (isset($_GET['success']) && $_GET['success'] == '1') {
    $success = "No-show recorded successfully.";
}

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['student_id'], $_POST['date'])) {
    $student_id = (int)$_POST["student_id"];
    $date = $_POST["date"];
    $reason = trim($_POST["reason"] ?? "");

    // 1. Get today's date and current time
    $today = date('Y-m-d');
    $now = date('H:i:s');

    // 2. Query to confirm this instructor had a drive scheduled with this student on this date
    $stmt = $conn->prepare("
        SELECT scheduled_time 
        FROM DriveSchedule 
        WHERE instructor_id = ? AND student_id = ? AND drive_date = ?
        LIMIT 1
    ");
    $stmt->bind_param("iis", $instructor_id, $student_id, $date);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 0) {
        $error = "You are not assigned to this student on this date, or no drive was scheduled.";
    } else {
        $stmt->bind_result($scheduled_time);
        $stmt->fetch();
        $stmt->close();

        // 3. Prevent logging for future drives
        if ($date > $today || ($date == $today && $scheduled_time > $now)) {
            $error = "Cannot log a no-show for a future or ongoing drive.";
        } else {
            // 4. Check for duplicates
            $checkQuery = $conn->prepare("SELECT COUNT(*) FROM NoShows WHERE student_id = ? AND date = ?");
            $checkQuery->bind_param("is", $student_id, $date);
            $checkQuery->execute();
            $checkQuery->bind_result($count);
            $checkQuery->fetch();
            $checkQuery->close();

            if ($count > 0) {
                $error = "This student already has a no-show logged for this date.";
            } else {
                // 5. Insert no-show record
                $stmt = $conn->prepare("INSERT INTO NoShows (student_id, date, reason) VALUES (?, ?, ?)");
                $stmt->bind_param("iss", $student_id, $date, $reason);
                if ($stmt->execute()) {
                    $stmt->close();
                    header("Location: log-noshow.php?success=1");
                    exit();
                } else {
                    $error = "Error: Could not record no-show.";
                }
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="stylesheet" href="styles.css">
    <meta charset="UTF-8">
    <title>Log No-Show</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            height: 100vh;
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .container {
            background: rgba(255,255,255,0.80);
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0,0,0,0.2);
            width: 400px;
            text-align: center;
        }
        label, select, input[type="date"], textarea {
            display: block;
            width: 100%;
            margin-bottom: 15px;
            padding: 8px;
        }
        input[type="submit"], form button {
            padding: 10px 15px;
            margin: 5px;
            background-color: #ff6c2c;
            border: none;
            color: white;
            border-radius: 5px;
            cursor: pointer;
        }
        .success { color: green; }
        .error { color: red; }
    </style>
</head>
<body>
<div class="container">
    <h2>Log a No-Show</h2>

    <?php if ($success): ?>
        <p class="success">No-show recorded successfully.</p>
        <form method="GET">
            <button type="submit">Log Another No-Show</button>
            <button type="button" onclick="window.location.href='instructor-dashboard.php'">Done</button>
        </form>
    <?php elseif ($error): ?>
        <p class="error"><?php echo $error; ?></p>
    <?php endif; ?>

    <?php if (!$success): ?>
        <form method="POST">
            <label for="student_id">Student:</label>
            <select name="student_id" required>
    <option value="">Select a student</option>
    <?php
    $instructor_id = $_SESSION['instructor_id'];
    $three_days_ago = date('Y-m-d', strtotime('-3 days'));

    $stmt = $conn->prepare("
        SELECT DISTINCT s.id, s.first_name, s.last_name
        FROM DriveSchedule ds
        JOIN Students s ON ds.student_id = s.id
        WHERE ds.instructor_id = ?
          AND ds.drive_date >= ?
        ORDER BY s.last_name, s.first_name
    ");
    $stmt->bind_param("is", $instructor_id, $three_days_ago);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $fullName = htmlspecialchars("{$row['last_name']}, {$row['first_name']}");
        echo "<option value='{$row['id']}'>{$fullName}</option>";
    }

    $stmt->close();
    ?>
</select>

            <label for="date">Date:</label>
            <input type="date" name="date" required>

            <label for="reason">Reason:</label>
            <textarea name="reason" placeholder="Optional"></textarea>

            <div style="display: flex; gap: 10px; justify-content: center; margin-top: 10px;">
            <input type="submit" value="Log No-Show" style="flex: 1; background-color: #ff6c2c; color: white; border: none; padding: 10px; border-radius: 5px; cursor: pointer;">
    
            <button type="button" onclick="window.location.href='instructor-dashboard.php'"
                style="flex: 1; background-color: #007bff; color: white; border: none; padding: 10px; border-radius: 5px; cursor: pointer;">
        Return to Dashboard
    </button>
</div>

        </form>
    <?php endif; ?>
</div>
</body>
</html>



