<?php
require 'db.php';

if (
    $_SERVER["REQUEST_METHOD"] === "POST" &&
    isset($_POST['search']) &&
    !empty($_SERVER['HTTP_X_REQUESTED_WITH']) &&
    strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest'
) {
    header('Content-Type: application/json');

    $query = trim($_POST['search']);
    $like = "%$query%";

    $stmt = $conn->prepare("
        SELECT id, first_name, last_name 
        FROM Students 
        WHERE 
            first_name LIKE ? OR 
            last_name LIKE ? OR 
            CONCAT(first_name, ' ', last_name) LIKE ?
        LIMIT 10
    ");
    $stmt->bind_param("sss", $like, $like, $like);
    $stmt->execute();
    $result = $stmt->get_result();

    $suggestions = [];
    while ($row = $result->fetch_assoc()) {
        $suggestions[] = [
            "id" => $row['id'],
            "first_name" => $row['first_name'],
            "last_name" => $row['last_name']
        ];
    }

    echo json_encode($suggestions);
    exit;
}
?>
