<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="stylesheet" href="styles.css">
    <meta charset="UTF-8">
    <title>Generate Student Printout</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            background: url('hotrod-1.jpg') no-repeat center center fixed;
            background-size: cover;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        
        .container {
            background: rgba(255, 255, 255, 0.7); /* 70% opacity white */
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.25);
            max-width: 500px;
            width: 90%;
            text-align: left;
            transform: translateY(60px);
        }
        
        .button-link {
            display: inline-block;
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            margin: 20px auto;
            display: block;
            width: fit-content;
        }

        .button-link:hover {
            background-color: #0056b3;
            
        h2 {
            text-align: center;
            margin-bottom: 20px;
        }

        label {
            font-weight: bold;
        }

        input[type="date"],
        select,
        input[type="submit"] {
            width: 100%;
            padding: 10px;
            margin-top: 8px;
            margin-bottom: 20px;
            border: 1px solid #ccc;
            border-radius: 6px;
            box-sizing: border-box;
            text-align: center;
        }

        input[type="submit"] {
            background-color: #007bff;
            color: white;
            border: none;
            cursor: pointer;
            text-align: center;
        }

        input[type="submit"]:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Generate Student Printout</h2>

        <form action="generate-printout.php" method="POST">
            <label for="sort_method">Sort By:</label>
            <select name="sort_method" id="sort_method" required>
                <option value="by_name">Student Last Name (A–Z)</option>
                <option value="by_section">Section Number</option>
                <option value="by_control">Control Number</option>
            </select>

            <label for="start_date">Start Date:</label>
            <input type="date" name="start_date" id="start_date" required>

            <label for="end_date">End Date:</label>
            <input type="date" name="end_date" id="end_date" required>

            <label for="output_format">Output Format:</label>
            <select name="output_format" id="output_format" required>
                <option value="excel">Excel (.xlsx)</option>
                <option value="pdf">PDF (.pdf)</option>
            </select>

                <input type="submit" value="Generate Printout">
            
            <a href="admin-dashboard.php" class="button-link">Back to Dashboard</a>
            </style>
        </form>
    </div>
</body>
</html>


