<?php
require 'db.php';

$term = $_GET['term'] ?? '';

if (strlen($term) < 2) {
    echo json_encode([]);
    exit;
}

$stmt = $conn->prepare("
    SELECT id, first_name, last_name 
    FROM Students 
    WHERE first_name LIKE ? OR last_name LIKE ?
    ORDER BY last_name ASC LIMIT 10
");

$like = "%" . $term . "%";
$stmt->bind_param("ss", $like, $like);
$stmt->execute();
$result = $stmt->get_result();

$matches = [];
while ($row = $result->fetch_assoc()) {
    $matches[] = [
        'id' => $row['id'],
        'name' => $row['last_name'] . ', ' . $row['first_name']
    ];
}

echo json_encode($matches);