<?php
require '../tpst/db.php';

$now = date('Y-m-d H:i:s');

// Get all uploaded documents where the associated test is in the past
$stmt = $conn->prepare("
    SELECT d.id, d.filename, d.test_log_id, a.test_date, a.test_time
    FROM TestDocuments d
    JOIN TestLogs l ON d.test_log_id = l.id
    JOIN TestAppointments a ON l.appointment_id = a.id
    WHERE CONCAT(a.test_date, ' ', a.test_time) < ?
");
$stmt->bind_param("s", $now);
$stmt->execute();
$result = $stmt->get_result();

$deleted = 0;
$failed = [];

while ($row = $result->fetch_assoc()) {
    $file_path = __DIR__ . "/uploads/applicant/{$row['test_log_id']}/{$row['filename']}";

    if (file_exists($file_path)) {
        if (unlink($file_path)) {
            // Delete DB record
            $del = $conn->prepare("DELETE FROM TestDocuments WHERE id = ?");
            $del->bind_param("i", $row['id']);
            $del->execute();
            $deleted++;
        } else {
            $failed[] = $file_path;
        }
    } else {
        // File missing but still in DB — remove stale record
        $del = $conn->prepare("DELETE FROM TestDocuments WHERE id = ?");
        $del->bind_param("i", $row['id']);
        $del->execute();
    }
}

echo "<h3>Cleanup complete</h3>";
echo "<p>✅ Deleted $deleted document(s).</p>";

if (!empty($failed)) {
    echo "<p style='color: red;'>⚠ Failed to delete the following files:</p><ul>";
    foreach ($failed as $f) {
        echo "<li>$f</li>";
    }
    echo "</ul>";
}
?>
