<?php
session_start();
require '../tpst/db.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    die("Access denied.");
}

$sub_id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
$new_type = $_GET['type'] ?? '';

$valid_types = ['basic', 'pro'];
if (!in_array($new_type, $valid_types) || $sub_id <= 0) {
    die("❌ Invalid request.");
}

$stmt = $conn->prepare("UPDATE Subscribers SET dashboard_type = ? WHERE sub_id = ?");
$stmt->bind_param("si", $new_type, $sub_id);
$stmt->execute();

echo "✅ Dashboard type for subscriber ID $sub_id updated to '$new_type'.";
?>
