<?php
require_once '../tpst/db.php'; // adjust path if needed
require_once '../includes/PHPMailer/PHPMailer.php';
require_once '../includes/PHPMailer/SMTP.php';
require_once '../includes/PHPMailer/Exception.php';

use includes\PHPMailer\PHPMailer;
use includes\PHPMailer\Exception;

// Helper: sanitize input
function clean($value) {
    return htmlspecialchars(trim($value));
}

// Define variables with default values before POST check
$first_name = '';
$last_name = '';
$username = '';
$email = '';
$tier = 'basic';
$password = '';
$confirm = '';
$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $first_name = clean($_POST['first_name'] ?? '');
    $last_name = clean($_POST['last_name'] ?? '');
    $username = strtolower(preg_replace('/[^a-zA-Z0-9]/', '', $_POST['username'] ?? ''));
    $email = clean($_POST['email'] ?? '');
    $tier = $_POST['tier_choice'] ?? 'basic';
    $password = $_POST['password'] ?? '';
    $confirm = $_POST['confirm_password'] ?? '';
}
    // Basic validation
    if (!$first_name || !$last_name || !$username || !$email || !$password || !$confirm) {
        $errors[] = "All fields are required.";
    }

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = "Invalid email format.";
    }

    if ($password !== $confirm) {
        $errors[] = "Passwords do not match.";
    }

    // Check username/email uniqueness
    $stmt = $conn->prepare("SELECT 1 FROM Subscribers WHERE username = ? OR email = ?");
    $stmt->bind_param("ss", $username, $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        $errors[] = "Username or email already in use.";
    }
    $stmt->close();

   if (empty($errors)) {
    $password_hash = password_hash($password, PASSWORD_DEFAULT);
    $trial_start = date('Y-m-d');

    $insert = $conn->prepare("
        INSERT INTO Subscribers (first_name, last_name, username, email, tier_choice, trial_start, password_hash)
        VALUES (?, ?, ?, ?, ?, ?, ?)
    ");
    $insert->bind_param("sssssss", $first_name, $last_name, $username, $email, $tier, $trial_start, $password_hash);

    if ($insert->execute()) {
        // Define subdomain URL for both redirect and email
        $subdomain_url = "https://{$username}.bookings.tandddrivingacademy.com";

        // Send confirmation email
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host = 'mail.tandddrivingacademy.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'no-reply@tandddrivingacademy.com';
            $mail->Password = '!ResetPassword1!';
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
            $mail->Port = 465;
        
            $mail->setFrom('no-reply@tandddrivingacademy.com', 'T&D Scheduler');
            $mail->addAddress($email, "$first_name $last_name");
        
            $mail->isHTML(true);
            $mail->Subject = 'Welcome to Your Scheduler Trial';
            $mail->Body    = "
                <h2>Welcome, $first_name!</h2>
                <p>Your 30-day trial for the <strong>$tier</strong> plan has started.</p>
                <p>You can access your dashboard here: <a href='$subdomain_url'>$subdomain_url</a></p>
            ";
        
            $mail->send();
        } catch (Exception $e) {
            // Optionally log email error
        }

        // Redirect to their subdomain
        header("Location: $subdomain_url");
        exit;
    } else {
        $errors[] = "Registration failed. Please try again.";
    }
}

?>

<!-- Optional: simple error display -->
<?php if (!empty($errors)): ?>
    <div style="color: red;">
        <ul>
            <?php foreach ($errors as $e): ?>
                <li><?= $e ?></li>
            <?php endforeach; ?>
        </ul>
    </div>
<?php endif; ?>
