<?php
require '../tpst/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $appointment_id = isset($_POST['appointment_id']) ? intval($_POST['appointment_id']) : 0;
    $result = $_POST['result'] ?? '';
    $notes = $_POST['notes'] ?? '';

    if (!$appointment_id || !in_array($result, ['pass', 'fail'])) {
        die("Invalid input.");
    }

    // Get test date from appointment
    $stmt = $conn->prepare("SELECT test_date FROM TestAppointments WHERE id = ?");
    $stmt->bind_param("i", $appointment_id);
    $stmt->execute();
    $result_appointment = $stmt->get_result()->fetch_assoc();
    $stmt->close();

    if (!$result_appointment) {
        die("Appointment not found.");
    }

    $test_date = $result_appointment['test_date'];

    // Insert into TestLogs
   $stmt = $conn->prepare("INSERT INTO TestLogs (appointment_id, test_date, result, examiner_notes) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("isss", $appointment_id, $test_date, $result, $examiner_notes);
    $stmt->execute();
    $log_id = $stmt->insert_id;
    $stmt->close();

    // Create storage folder
    $folder_name = date("Ymd", strtotime($test_date)) . "-appt-{$appointment_id}-log-{$log_id}";
    $folder_path = __DIR__ . "/test-packets/" . $folder_name;

    if (!is_dir($folder_path)) {
        mkdir($folder_path, 0775, true);
    }

    // Document types
    // Document types
$types = ['DE_964', 'IMPACT', 'DL_40', 'DL_14A', 'DL_14B', 'Other'];

foreach ($types as $type) {
    $key = strtolower($type);
    if (!empty($_FILES[$key]['name'][0])) {
        for ($i = 0; $i < count($_FILES[$key]['name']) && $i < 2; $i++) {
            $tmp = $_FILES[$key]['tmp_name'][$i];
            $original = basename($_FILES[$key]['name'][$i]);
            $stored = uniqid() . '-' . preg_replace('/\s+/', '_', $original);
            $dest = $folder_path . '/' . $stored;

            if (move_uploaded_file($tmp, $dest)) {
                $stmt = $conn->prepare("INSERT INTO TestDocuments (test_log_id, doc_type, filename) VALUES (?, ?, ?)");
                $stmt->bind_param("iss", $log_id, $type, $stored);
                $stmt->execute();
                $stmt->close();
            }
        }
    }
}

    header("Location: view-test-packet.php?id=" . $log_id);
    exit;
} else {
    echo "Invalid request.";
}
