<?php

// Define variables with default values before POST check
$first_name = '';
$last_name = '';
$username = '';
$email = '';
$tier = 'basic';
$password = '';
$confirm = '';

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Subscriber Registration</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(to right, #2c3e50, #34495e);
            color: #fff;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .container {
            background: rgba(255,255,255,0.1);
            padding: 30px;
            border-radius: 10px;
            width: 400px;
            box-shadow: 0 0 10px rgba(0,0,0,0.3);
        }
        label, input, select {
            display: block;
            width: 100%;
            margin-bottom: 15px;
        }
        input, select {
            padding: 8px;
            border: none;
            border-radius: 5px;
        }
        input[type="submit"] {
            background-color: #3498db;
            color: white;
            cursor: pointer;
            font-weight: bold;
        }
        input[type="submit"]:hover {
            background-color: #2980b9;
        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        .error {
            background: #e74c3c;
            padding: 10px;
            margin-bottom: 15px;
            border-radius: 5px;
            color: white;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Create Your Account</h2>

        <!-- Display PHP errors if present -->
        <?php if (!empty($errors)): ?>
            <div class="error">
                <ul>
                    <?php foreach ($errors as $e): ?>
                        <li><?= $e ?></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="register-subscriber.html" method="POST">
            <label for="first_name">First Name</label>
            <input type="text" name="first_name" value="<?= htmlspecialchars($first_name) ?>" required>

            <label for="last_name">Last Name</label>
            <input type="text" name="last_name" value="<?= htmlspecialchars($last_name) ?>" required>

            <label for="username">Username</label>
            <input type="text" name="username" value="<?= htmlspecialchars($username) ?>" required>

            <label for="email">Email</label>
            <input type="email" name="email" value="<?= htmlspecialchars($email) ?>" required>

            <label for="tier_choice">Choose a Plan</label>
            <select name="tier_choice" required>
                <option value="basic" <?= $tier === 'basic' ? 'selected' : '' ?>>Basic (Free Trial)</option>
                <option value="mid" <?= $tier === 'mid' ? 'selected' : '' ?>>Mid Tier ($19.99/month)</option>
                <option value="pro" <?= $tier === 'pro' ? 'selected' : '' ?>>Pro ($29.99/month)</option>
            </select>

            <label for="password">Password</label>
            <input type="password" name="password" required>

            <label for="confirm_password">Confirm Password</label>
            <input type="password" name="confirm_password" required>

            <input type="submit" value="Start Free Trial">
        </form>
    </div>
</body>
</html>
