<?php
require '../tpst/db.php';
require '../includes/auth.php'; // if needed

// Ensure connection to the correct DB
mysqli_select_db($conn, 'tandddri_TPST-C0207');

$date = date("Y-m-d");

$stmt = $conn->prepare("SELECT first_name, last_name, email, age_group, arrival_time FROM TestAppointments WHERE test_date = ?");
$stmt->bind_param("s", $date);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Today's Appointments</title>
    <link rel="stylesheet" href="../styles.css">
    <style>
        .container {
            max-width: 700px;
            margin: 60px auto;
            background: #fff;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 0 12px rgba(0,0,0,0.1);
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 10px;
            border-bottom: 1px solid #ccc;
        }
        th {
            background: #f4f4f4;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>Appointments for Today (<?= htmlspecialchars($date) ?>)</h2>
    <table>
        <thead>
            <tr>
                <th>Name</th>
                <th>Email</th>
                <th>Age Group</th>
                <th>Arrival Time</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?= htmlspecialchars($row['first_name'] . ' ' . $row['last_name']) ?></td>
                    <td><?= htmlspecialchars($row['email']) ?></td>
                    <td><?= htmlspecialchars($row['age_group']) ?></td>
                    <td><?= htmlspecialchars($row['arrival_time']) ?></td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>
</body>
</html>
