<?php
require '../tpst/db.php'; // Adjust path if needed

// Get all appointments for the next 7 days
$today = date("Y-m-d");
$two_weeks = date("Y-m-d", strtotime("+14 days"));

$stmt = $conn->prepare("
    SELECT id, first_name, last_name, email, phone, dob, test_date, test_time, age_group, status
    FROM TestAppointments
    WHERE test_date BETWEEN ? AND ?
    ORDER BY test_date ASC, test_time ASC
");
$stmt->bind_param("ss", $today, $two_weeks);

$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>View Appointments – This Week</title>
    <link rel="stylesheet" href="styles.css"> <!-- Optional shared stylesheet -->
    <style>
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(to right, #2c3e50, #34495e);
            color: white;
            padding: 20px;
        }
        table {
            background: white;
            color: black;
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 10px;
            border: 1px solid #999;
            text-align: center;
        }
        th {
            background-color: #333;
            color: white;
        }
        form {
            display: inline;
        }
        button {
            padding: 6px 10px;
            margin: 0 2px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        .accept-btn {
            background-color: #27ae60;
            color: white;
        }
        .reject-btn {
            background-color: #c0392b;
            color: white;
        }
    </style>
</head>
<body>
    <div style="text-align: center; margin-bottom: 20px;">
                        <a href="testing.php" style="
                            display: inline-block;
                            padding: 10px 20px;
                            background-color: #2ecc71;
                            color: white;
                            font-weight: bold;
                            text-decoration: none;
                            border-radius: 6px;
                            box-shadow: 0 2px 6px rgba(0,0,0,0.2);
                        ">
                            ← Back to TPST Control Panel
                        </a>
</div>
    <div style="text-align: center; margin-bottom: 20px;">
    <a href="toggle-availability.php" style="
        display: inline-block;
        padding: 10px 20px;
        background-color: #3498db;
        color: white;
        font-weight: bold;
        text-decoration: none;
        border-radius: 6px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.2);
    ">
        Toggle Morning Availability
    </a>
</div>


<h1>This Week's Driving Test Appointments</h1>

<table>
    <thead>
        <tr>
            <th>Name</th>
            <th>Email</th>
            <th>Phone</th>
            <th>Test Date</th>
            <th>Time</th>
            <th>Age Group</th>
            <th>Status</th>
        </tr>
    </thead>
    <tbody>
        <?php if ($result->num_rows > 0): ?>
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?= htmlspecialchars($row['first_name'] . ' ' . $row['last_name']); ?></td>
                    <td><?= htmlspecialchars($row['email']); ?></td>
                    <td><?= htmlspecialchars($row['phone']); ?></td>
                    <td><?= htmlspecialchars($row['test_date']); ?></td>
                    <td><?= htmlspecialchars($row['test_time']); ?></td>
                    <td><?= htmlspecialchars($row['age_group']); ?></td>
                    <td>
                        <?php if ($row['status'] === 'pending'): ?>
                            <form method="post" action="update-test-status.php">
                                <input type="hidden" name="appointment_id" value="<?= $row['id']; ?>">
                                <input type="hidden" name="new_status" value="accepted">
                                <button type="submit" class="accept-btn">Accept</button>
                            </form>
                            <form method="post" action="update-test-status.php">
                                <input type="hidden" name="appointment_id" value="<?= $row['id']; ?>">
                                <input type="hidden" name="new_status" value="rejected">
                                <button type="submit" class="reject-btn">Reject</button>
                            </form>
                        <?php else: ?>
                            <?= ucfirst($row['status']); ?>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endwhile; ?>
        <?php else: ?>
            <tr><td colspan="7">No appointments scheduled this week.</td></tr>
        <?php endif; ?>
    </tbody>
</table>

</body>
</html>
