<?php
session_start();
require 'db.php';

if (!isset($_SESSION['admin_id'])) {
    header("Location: admin-login.php");
    exit();
}

$success = "";
$error = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $student_id = $_POST['student_id'] ?? '';
    $de964_number = $_POST['de964_number'] ?? null;
    $ade1317_number = $_POST['ade1317_number'] ?? null;
    $duplicate_de964 = $_POST['duplicate_de964'] ?? null;
    $duplicate_ade1317 = $_POST['duplicate_ade1317'] ?? null;
    $permit_number = $_POST['permit_number'] ?? null;
    $permit_received_at = $_POST['permit_received_at'] ?? null;
    $classroom_completed = isset($_POST['classroom_completed']) ? (int)$_POST['classroom_completed'] : 0;

    if (!empty($permit_received_at)) {
        $permit_received_at = date('Y-m-d', strtotime($permit_received_at));
    }

    // Validation for proper prefix format
    if ($de964_number && !preg_match("/^DE\\d{1,17}$/", $de964_number)) {
        $error = "DE-964 number must begin with 'DE' followed by digits.";
    } elseif ($ade1317_number && !preg_match("/^ADE\\d{1,17}$/", $ade1317_number)) {
        $error = "ADE-1317 number must begin with 'ADE' followed by digits.";
    } elseif ($duplicate_de964 && !preg_match("/^DE\\d{1,17}$/", $duplicate_de964)) {
        $error = "Duplicate DE-964 must begin with 'DE' followed by digits.";
    } elseif ($duplicate_ade1317 && !preg_match("/^ADE\\d{1,17}$/", $duplicate_ade1317)) {
        $error = "Duplicate ADE-1317 must begin with 'ADE' followed by digits.";
    } elseif ($student_id) {
        if (!empty($permit_received_at)) {
            $stmt = $conn->prepare("
                UPDATE Students 
                SET de964_number = ?, ade1317_number = ?, duplicate_de964 = ?, duplicate_ade1317 = ?, 
                    permit_number = ?, permit_received_at = ?, classroom_completed = ? 
                WHERE id = ?
            ");
            $stmt->bind_param("ssssssii", $de964_number, $ade1317_number, $duplicate_de964, $duplicate_ade1317, $permit_number, $permit_received_at, $classroom_completed, $student_id);
        } else {
            $stmt = $conn->prepare("
                UPDATE Students 
                SET de964_number = ?, ade1317_number = ?, duplicate_de964 = ?, duplicate_ade1317 = ?, 
                    permit_number = ?, classroom_completed = ? 
                WHERE id = ?
            ");
            $stmt->bind_param("ssssssi", $de964_number, $ade1317_number, $duplicate_de964, $duplicate_ade1317, $permit_number, $classroom_completed, $student_id);
        }

        if ($stmt->execute()) {
            $success = "Certificate details updated successfully.";
        } else {
            $error = "Error updating certificate info.";
        }

        $stmt->close();
    } else {
        $error = "Please select a student.";
    }

    if (empty($success) && empty($error)) {
        $error = "Unknown error. Please try again.";
    }
}


$students = $conn->query("SELECT id, first_name, last_name FROM Students ORDER BY last_name, first_name");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="stylesheet" href="styles.css">
    <meta charset="UTF-8">
    <title>Update Certificate Info</title>
    <style>
        body { font-family: Arial, sans-serif; /* background-color: #f4f4f4;*/ padding: 20px; }
        .container { max-width: 600px; margin: auto; background: rgba(255,255,255,0.80); padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        h2 { text-align: center; }
        label { display: block; margin-top: 10px; }
        select, input[type=text], input[type=submit] {
            width: 100%; padding: 8px; margin-top: 5px; border-radius: 4px; border: 1px solid #ccc;
        }
        .autocomplete-wrapper {
    position: relative;
}

    #suggestions {
        position: absolute;
        top: 100%;
        left: 0;
        width: 100%;
        z-index: 10;
        background: #fff;
        border: 1px solid #ccc;
        border-top: none;
        max-height: 200px;
        overflow-y: auto;
        display: none;
    }
    
    #suggestions div {
        padding: 8px;
        cursor: pointer;
    }
    
    #suggestions div:hover {
        background-color: #f0f0f0;
    }

        .success { color: green; }
        .error { color: red; }
        
    </style>
</head>
<body>
<div class="container">
    <h2>Update Student Records</h2>
    <?php if ($success): ?><p class="success"><?php echo $success; ?></p><?php endif; ?>
    <?php if ($error): ?><p class="error"><?php echo $error; ?></p><?php endif; ?>

    <form method="post">
        <label for="student-search">Search Student:</label>
        <div class="autocomplete-wrapper">
            <input type="text" id="studentSearch" placeholder="Start typing..." autocomplete="off" required>
            <div id="suggestions"></div>
        </div>
        <input type="hidden" name="student_id" id="studentId" required>

        <label for="permit_number">Learner’s Permit Number (Optional):</label>
        <input type="text" name="permit_number" id="permit_number" placeholder="Enter permit number if known">
        <label for="classroom_completed">Classroom Completed:</label>
        <select name="classroom_completed" id="classroom_completed" required>
            <option value="0">No</option>
            <option value="1">Yes</option>
        </select>
        <label for="permit_received_at">Start Reinstatement Countdown Date:</label>
        <input type="date" name="permit_received_at" id="permit_received_at" placeholder="Select a start date (optional)">
        <p style="font-size: 0.85em; color: #555; margin-top: 5px;">
            If you want to start the 6-month drive time countdown now, choose the permit receipt date.
        </p>

        <label for="de964_number">DE-964 Control Number (Teens):</label>
        <input type="text" name="de964_number" id="de964_number" placeholder="Enter DE-964 if applicable">

        <label for="ade1317_number">ADE-1317 Control Number (Adults):</label>
        <input type="text" name="ade1317_number" id="ade1317_number" placeholder="Enter ADE-1317 if applicable">

        <label for="duplicate_de964">Duplicate DE-964 Control Number:</label>
        <input type="text" name="duplicate_de964" id="duplicate_de964" placeholder="Enter duplicate DE-964 if reissued">

        <label for="duplicate_ade1317">Duplicate ADE-1317 Control Number:</label>
        <input type="text" name="duplicate_ade1317" id="duplicate_ade1317" placeholder="Enter duplicate ADE-1317 if reissued">

        <input type="submit" value="Update Certificate Info">
    </form>
    <form action="admin-dashboard.php" method="get" style="margin-top: 15px;">
    <input type="submit" value="Done" style="background-color: #007bff; color: white;">
</form>
</div>
<script src="js/update-certificate-lookup.js"></script>
</body>
</html>

