<?php
session_start();
require 'db.php';

// require_once 'vendor/autoload.php'; // If not already included
require_once 'includes/PHPMailer/PHPMailer.php';
require_once 'includes/PHPMailer/Exception.php';
require_once 'includes/PHPMailer/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$success = $_SESSION['upload_success'] ?? "";
$error = $_SESSION['upload_error'] ?? "";
unset($_SESSION['upload_success'], $_SESSION['upload_error']);

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_FILES["csv_file"])) {
    $file = $_FILES["csv_file"]["tmp_name"];
    $section_code = trim($_POST["section_code"]);

    if (($handle = fopen($file, "r")) !== false) {
        $header = fgetcsv($handle); // Skip the first row (column titles)
        $successCount = 0;
        $duplicateCount = 0;

        while (($data = fgetcsv($handle, 1000, ",")) !== false) {
        // If your header is: first_name,last_name,email,ssn_last4,section_code
        $first_name = trim($data[0]);
        $last_name = trim($data[1]);
        $email = trim($data[2]);
        $ssn_last4 = trim($data[3]);
        $section_code = trim($data[4]);

// 1. Auto-generate password (raw and hashed)
        $password_raw = strtolower(substr($first_name, 0, 1) . $last_name . $ssn_last4);
        $password_hashed = password_hash($password_raw, PASSWORD_DEFAULT);

// 2. Generate confirmation token
        $pw_token_confirm = bin2hex(random_bytes(16));
        
// Check for duplicate by email
        $check = $conn->prepare("SELECT id FROM Students WHERE email = ?");
        $check->bind_param("s", $email);
        $check->execute();
        $check->store_result();
        
        if ($check->num_rows > 0) {
            $duplicateCount++;
            $check->close();
            continue; // Skip this student
        }
        $check->close();

// 3. Insert student into database
        $stmt = $conn->prepare("INSERT INTO Students 
        (first_name, last_name, email, ssn_last4, section_code, password, pw_token_confirm, is_confirmed)
        VALUES (?, ?, ?, ?, ?, ?, ?, 0)
");
        $stmt->bind_param("sssssss", $first_name, $last_name, $email, $ssn_last4, $section_code, $password_hashed, $pw_token_confirm
);
        $stmt->execute();
        $successCount++;

        $stmt->close();
        
        $mail = new PHPMailer(true);
        $mail->CharSet = 'UTF-8';
        
    try {
        $mail->isSMTP();
        $mail->Host = 'mail.tandddrivingacademy.com';
        $mail->SMTPAuth = true;
        $mail->Username = 'no-reply@tandddrivingacademy.com';
        $mail->Password = '!ResetPassword1!';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port = 465;
    
        $mail->setFrom('no-reply@tandddrivingacademy.com', 'T&D Driving Academy');
        $mail->addAddress($email, "$first_name $last_name");
    
        $mail->isHTML(true);
        $mail->Subject = 'Welcome to T&D Driving Academy - Confirm Your Account';
    
        $confirmation_link = "https://bookings.tandddrivingacademy.com/confirm-account.php?pw_token_confirm=$pw_token_confirm";

        $mail->Body = "
            <p>Hello <strong>$first_name</strong>,</p>
            <p>Welcome to T&D Driving Academy! We've created your student account.</p>
            <p><strong>Login Email:</strong> $email<br>
            <strong>Temporary Password:</strong> $password_raw</p>
            <p><a href='$confirmation_link'>Click here to confirm your account and set your permanent password</a></p>
            <p>After confirmation, you may log in and reset your password anytime.</p>
            <p>Best regards,<br>T&D Driving Academy</p>
        ";

        $mail->send();
    } catch (Exception $e) {
        error_log("Email error for $email {$mail->ErrorInfo}");
    }

        }

        fclose($handle);
        $_SESSION['upload_success'] = "$successCount students added. $duplicateCount duplicates skipped.";
        header("Location: upload-students.php");
        exit();
    } else {
        $_SESSION['upload_error'] = "Failed to open CSV file.";
        header("Location: upload-students.php");
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="stylesheet" href="styles.css">
    <meta charset="UTF-8">
    <title>Upload Students</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        /*    background: #f7f7f7;  */ /* stylesheet default */
            height: 100vh;
            margin: 0;
            display: flex;
            flex-direction: column; /* ADD THIS LINE */
            justify-content: center;
            align-items: center;
        }
        .container {
            background: rgba(255,255,255,0.80);
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0,0,0,0.2);
            width: 400px;
            text-align: center;
            transform: translateY(60px);
        }
        input, select {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
        }
        input[type="submit"], button {
            background-color: #ff6c2c;
            color: white;
            border: none;
            cursor: pointer;
            padding: 10px;
            width: 48%;
            margin: 5px 1%;
            border-radius: 5px;
        }
        .success { color: green; margin-bottom: 15px; }
        .error { color: red; margin-bottom: 15px; }
        
        .template-container {
            background: rgba(255,255,255,0.75);
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.15);
            width: 400px;
            text-align: center;
            margin-top: 30px;
            transform: translateY(60px);
        }
        
        .download-button {
            display: inline-block;
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            margin-top: 10px;
        }
        
        .download-button:hover {
            background-color: #0056b3;
        }

    </style>
</head>
<body>
    <div class="container">
        <h2>Upload Students CSV</h2>

        <?php if ($success): ?><p class="success"><?= $success ?></p><?php endif; ?>
        <?php if ($error): ?><p class="error"><?= $error ?></p><?php endif; ?>

        <?php if (!$success): ?>
        <form method="post" enctype="multipart/form-data">
            <input type="text" name="section_code" placeholder="Section Code (e.g., T.00.2025 or A.01.2025)" pattern="[TA]\.\d{2}\.\d{4}" title="Format: T.01.2025 or A.00.2025" required>
            <input type="file" name="csv_file" accept=".csv" required>
            <input type="submit" value="Upload Students">
        </form>
        <?php else: ?>
        <form method="get">
            <button type="submit">Upload Another File</button>
            <button type="button" onclick="window.location.href='admin-dashboard.php'">Done</button>
        </form>
        <?php endif; ?>
    </div>
    <div class="template-container">
    <h3>Need a Template?</h3>
    <p>Click below to download a pre-formatted Excel spreadsheet. Fill it out, save as CSV, and upload.</p>
    <a href="downloads/student-upload-template.xlsx" class="download-button" download>Download Template</a>
    <div style="text-align: center; margin-top: 30px;">
    <a href="admin-dashboard.php" style="
        display: inline-block;
        padding: 12px 24px;
        background-color: #007bff;
        color: white;
        text-decoration: none;
        border-radius: 6px;
        font-weight: bold;
        box-shadow: 0 2px 5px rgba(0,0,0,0.2);
        transition: background-color 0.3s;
    ">
        Back to Dashboard
    </a>
</div>
</div>
</body>
</html>


