<?php\
// booking-form.php \'97 place this in your public_html folder\
\
// TEMPORARY: Show PHP errors for debugging\
error_reporting(E_ALL);\
ini_set('display_errors', 1);\
\
$host = "localhost";\
$db = "tandddri_Student_Drivers";\
$user = "tandddri_tonyramey";\
$pass = "!S0ngw3av3r1!";\
\
$conn = new mysqli($host, $user, $pass, $db);\
if ($conn->connect_error) \{\
    die("Connection failed: " . $conn->connect_error);\
\}\
\
// Fetch available drive slots that aren't full yet\
$slots = $conn->query("\
    SELECT ds.id, ds.date, ds.time_start, ds.time_end, ds.instructor_name,\
        (SELECT COUNT(*) FROM drive_bookings WHERE slot_id = ds.id) as current_booked,\
        ds.max_students\
    FROM drive_slots ds\
    HAVING current_booked < ds.max_students\
    ORDER BY ds.date, ds.time_start\
");\
\
if ($_SERVER["REQUEST_METHOD"] === "POST") \{\
    $student_name = $conn->real_escape_string($_POST['student_name'] ?? '');\
    $student_email = $conn->real_escape_string($_POST['student_email'] ?? '');\
    $slot_id = intval($_POST['slot_id'] ?? 0);\
\
    if ($student_name && $student_email && $slot_id) \{\
        // Check again if the slot is full\
        $check = $conn->query("SELECT COUNT(*) as total FROM drive_bookings WHERE slot_id = $slot_id");\
        $row = $check->fetch_assoc();\
\
        $limitCheck = $conn->query("SELECT max_students FROM drive_slots WHERE id = $slot_id");\
        $limit = $limitCheck->fetch_assoc();\
\
        if ($row['total'] < $limit['max_students']) \{\
            $stmt = $conn->prepare("INSERT INTO drive_bookings (student_name, student_email, slot_id) VALUES (?, ?, ?)");\
            $stmt->bind_param("ssi", $student_name, $student_email, $slot_id);\
            $stmt->execute();\
            echo "<p style='color: green;'>\uc0\u9989  Booking confirmed! We'll see you at your drive time.</p>";\
        \} else \{\
            echo "<p style='color: red;'>\uc0\u9940  Sorry, that slot just filled up. Please choose another.</p>";\
        \}\
    \} else \{\
        echo "<p style='color: red;'>All fields are required.</p>";\
    \}\
\}\
?>\
\
<!DOCTYPE html>\
<html>\
<head>\
    <title>Book Your Drive Time</title>\
    <style>\
        body \{ font-family: Arial, sans-serif; padding: 20px; max-width: 600px; margin: auto; \}\
        input, select \{ width: 100%; padding: 10px; margin-top: 10px; margin-bottom: 20px; \}\
        button \{ padding: 10px 20px; font-size: 16px; \}\
        h2 \{ color: #333; \}\
    </style>\
</head>\
<body>\
    <h2>Book Your Drive Time</h2>\
    <form method="POST">\
        <label for="student_name">Your Full Name</label>\
        <input type="text" name="student_name" required>\
\
        <label for="student_email">Your Email Address</label>\
        <input type="email" name="student_email" required>\
\
        <label for="slot_id">Choose a Time Slot</label>\
        <select name="slot_id" required>\
            <option value="">-- Select a Slot --</option>\
            <?php while ($slot = $slots->fetch_assoc()): ?>\
                <option value="<?php echo $slot['id']; ?>">\
                    <?php echo date("M d", strtotime($slot['date'])) . " | " .\
                        substr($slot['time_start'], 0, 5) . "\'96" . substr($slot['time_end'], 0, 5) .\
                        " with " . $slot['instructor_name'] .\
                        " (" . ($slot['max_students'] - $slot['current_booked']) . " spots left)"; ?>\
                </option>\
            <?php endwhile; ?>\
        </select>\
\
        <button type="submit">Book Drive Time</button>\
    </form>\
</body>\
</html>\
}