<?php
session_start();
require 'db.php';

$success = $_SESSION['instructor_success'] ?? "";
$error = $_SESSION['instructor_error'] ?? "";

// Clear messages after display
unset($_SESSION['instructor_success'], $_SESSION['instructor_error']);

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $password = password_hash(trim($_POST['password']), PASSWORD_DEFAULT);

    $stmt = $conn->prepare("INSERT INTO Instructors (name, email, password) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $name, $email, $password);

    if ($stmt->execute()) {
        $_SESSION['instructor_success'] = "Instructor created successfully!";
    } else {
        // Catch duplicate email and show clean message
        if (str_contains($stmt->error, 'Duplicate entry')) {
            $_SESSION['instructor_error'] = "This email is already registered.";
        } else {
            $_SESSION['instructor_error'] = "Error: " . $stmt->error;
        }
    }

    $stmt->close();
    header("Location: create-instructor.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Create Instructor</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f7f7f7;
            height: 100vh;
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0,0,0,0.2);
            width: 360px;
            text-align: center;
        }
        input {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
        }
        input[type="submit"], button {
            background-color: #ff6c2c;
            color: white;
            border: none;
            cursor: pointer;
            padding: 10px;
            width: 48%;
            margin: 5px 1%;
            border-radius: 5px;
        }
        .success { color: green; margin-bottom: 15px; }
        .error { color: red; margin-bottom: 15px; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Create Instructor</h2>

        <?php if ($success): ?><p class="success"><?= $success ?></p><?php endif; ?>
        <?php if ($error): ?><p class="error"><?= $error ?></p><?php endif; ?>

        <?php if (!$success): ?>
        <form method="post">
            <input type="text" name="name" placeholder="Instructor Name" required>
            <input type="email" name="email" placeholder="Email Address" required>
            <input type="password" name="password" placeholder="Password" required>
            <input type="submit" value="Create Instructor">
        </form>
        <?php else: ?>
        <form method="get">
            <button type="submit">Add Another Instructor</button>
            <button type="button" onclick="window.location.href='index.php'">Done</button>
        </form>
        <?php endif; ?>
    </div>
</body>
</html>

