<?php
session_start();
require 'db.php';

$success = $_SESSION['student_success'] ?? "";
$error = $_SESSION['student_error'] ?? "";

unset($_SESSION['student_success'], $_SESSION['student_error']);

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $first_name = trim($_POST['first_name']);
    $last_name = trim($_POST['last_name']);
    $email = trim($_POST['email']);
    $password = password_hash(trim($_POST['password']), PASSWORD_DEFAULT);
    $section_code = trim($_POST['section_code']);

    $stmt = $conn->prepare("INSERT INTO Students (first_name, last_name, email, password, section_code) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sssss", $first_name, $last_name, $email, $password, $section_code);

    if ($stmt->execute()) {
        $_SESSION['student_success'] = "Student added successfully!";
    } else {
        if (str_contains($stmt->error, 'Duplicate entry')) {
            $_SESSION['student_error'] = "This email is already registered.";
        } else {
            $_SESSION['student_error'] = "Error: " . $stmt->error;
        }
    }

    $stmt->close();
    header("Location: create-student.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Create Student</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f7f7f7;
            height: 100vh;
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0,0,0,0.2);
            width: 360px;
            text-align: center;
        }
        input, select {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
        }
        input[type="submit"], button {
            background-color: #ff6c2c;
            color: white;
            border: none;
            cursor: pointer;
            padding: 10px;
            width: 48%;
            margin: 5px 1%;
            border-radius: 5px;
        }
        .success { color: green; margin-bottom: 15px; }
        .error { color: red; margin-bottom: 15px; }
    </style>
</head>
<body>
<div class="container">
    <h2>Create Student</h2>

    <?php if ($success): ?><p class="success"><?= $success ?></p><?php endif; ?>
    <?php if ($error): ?><p class="error"><?= $error ?></p><?php endif; ?>

    <?php if (!$success): ?>
    <form method="post">
        <input type="text" name="first_name" placeholder="First Name" required>
        <input type="text" name="last_name" placeholder="Last Name" required>
        <input type="email" name="email" placeholder="Email Address" required>
        <input type="password" name="password" placeholder="Password" required>
        <input type="text" name="section_code" placeholder="Section Code (e.g., T.05.2025 or A.00.2025)" pattern="[TA]\.\d{2}\.\d{4}" title="Format: T.01.2025 or A.00.2025" required>
        <input type="submit" value="Create Student">
    </form>
    <?php else: ?>
    <form method="get">
        <button type="submit">Add Another Student</button>
        <button type="button" onclick="window.location.href='admin-dashboard.php'">Done</button>
    </form>
    <?php endif; ?>
</div>
</body>
</html>



