<?php
require 'db.php';

header('Content-Type: application/json');

if (!isset($_GET['student_id'])) {
    echo json_encode([]);
    exit;
}

$student_id = intval($_GET['student_id']);
$data = [];

// Fetch lessons marked I or F for this student
$stmt = $conn->prepare("
    SELECT lg.code, lg.label
    FROM DriveSchedule ds
    INNER JOIN lesson_groups lg ON ds.lesson_group_id = lg.id
    WHERE ds.student_id = ? AND ds.lesson_status IN ('I', 'F')
");
$stmt->bind_param("i", $student_id);
$stmt->execute();
$result = $stmt->get_result();

while ($row = $result->fetch_assoc()) {
    $data[] = ['code' => $row['code'], 'label' => $row['label']];
}
$stmt->close();

// Fallback to all lesson groups if student has no 'I' or 'F'
if (empty($data)) {
    $fallback = $conn->query("SELECT code, label FROM lesson_groups ORDER BY id ASC");
    while ($row = $fallback->fetch_assoc()) {
        $data[] = ['code' => $row['code'], 'label' => $row['label']];
    }
}

echo json_encode($data);
?>




