<?php
session_start();
require 'db.php';

if (!isset($_SESSION['instructor_id'])) {
    header("Location: instructor-login.php");
    exit();
}

$instructor_id = $_SESSION['instructor_id'];
$instructor_name = $_SESSION['instructor_name'] ?? 'Instructor';

$today = date('Y-m-d');
$ten_days_later = date('Y-m-d', strtotime('+10 days'));

$today = date('Y-m-d');
$ten_days_later = date('Y-m-d', strtotime('+10 days'));

$stmt = $conn->prepare("
    SELECT 
        ia.available_date, 
        ia.start_time, 
        ia.end_time, 
        s.id AS student_id,
        s.first_name, 
        s.last_name
    FROM BookedDrives bd
    JOIN InstructorAvailability ia ON bd.slot_id = ia.id
    JOIN Students s ON bd.student_id = s.id
    WHERE ia.instructor_id = ? 
      AND ia.available_date BETWEEN ? AND ?
    ORDER BY ia.available_date ASC, ia.start_time ASC
");


$stmt->bind_param("iss", $instructor_id, $today, $ten_days_later);
$stmt->execute();
$drives = $stmt->get_result();
$stmt->close();

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Instructor Dashboard</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f9f9f9; padding: 20px; }
        .container { max-width: 900px; margin: auto; background: #fff; padding: 30px; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        h2 { margin-bottom: 20px; text-align: center; }
        .button-group { text-align: center; margin-bottom: 25px; }
        .button-group a { margin: 0 10px; text-decoration: none; padding: 10px 20px; background-color: #007bff; color: white; border-radius: 5px; display: inline-block; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ccc; padding: 10px; text-align: left; }
        th { background-color: #f0f0f0; }
        .no-drives { text-align: center; color: gray; margin-top: 20px; }
    </style>
</head>
<body>
<div class="container">
    <h2>Welcome, <?php echo htmlspecialchars($instructor_name); ?> – Upcoming Drives (Next 10 Days)</h2>

    <div class="button-group">
        <a href="log-noshow.php">Log No-Show</a>
        <a href="log-drive.php">Log Drive Time</a>
        <a href="instructor-availability.php">Submit Availability</a>
        <a href="instructor-login.php">Logout</a>
    </div>

    <?php if ($drives->num_rows > 0): ?>
        <table>
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Student</th>
                    <th>Type</th>
                    <th>Minutes</th>
                </tr>
            </thead>
            <tbody>
<?php while ($row = $drives->fetch_assoc()): ?>
    <tr>
        <td><?= htmlspecialchars($row['available_date']) ?></td>
        <td><?= htmlspecialchars($row['first_name'] . ' ' . $row['last_name']) ?></td>
        <td><?= htmlspecialchars($row['start_time'] . ' - ' . $row['end_time']) ?></td>
        <?php
$studentId = $row['student_id'];

// BTW minutes
$btwStmt = $conn->prepare("SELECT SUM(minutes) AS btw_minutes FROM DriveSchedule WHERE student_id = ? AND drive_type = 'BTW'");
$btwStmt->bind_param("i", $studentId);
$btwStmt->execute();
$btwResult = $btwStmt->get_result();
$btwRow = $btwResult->fetch_assoc();
$btwStmt->close();

// OB minutes
$obStmt = $conn->prepare("SELECT SUM(minutes) AS ob_minutes FROM DriveSchedule WHERE student_id = ? AND drive_type = 'OB'");
$obStmt->bind_param("i", $studentId);
$obStmt->execute();
$obResult = $obStmt->get_result();
$obRow = $obResult->fetch_assoc();
$obStmt->close();
?>

        <td>
    BTW: <?= $btwRow['btw_minutes'] !== null ? htmlspecialchars($btwRow['btw_minutes']) : '0' ?> |
    OB: <?= $obRow['ob_minutes'] !== null ? htmlspecialchars($obRow['ob_minutes']) : '0' ?>
</td>


    </tr>
<?php endwhile; ?>
</tbody>

        </table>
    <?php else: ?>
        <p class="no-drives">No scheduled drives for the next 10 days.</p>
    <?php endif; ?>
</div>
</body>
</html>

