<?php
session_start();

$conn = new mysqli("localhost", "tandddri_admin", "!S0ngw3av3r1!", "tandddri_Students");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$success = "";
$error = "";

// Handle redirect success message
if (isset($_GET['success']) && $_GET['success'] == '1') {
    $success = "No-show recorded successfully.";
}

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['student_id'], $_POST['date'])) {
    $student_id = $_POST["student_id"];
    $date = $_POST["date"];
    $reason = trim($_POST["reason"] ?? "");

    // Check for duplicates
    $checkQuery = $conn->prepare("SELECT COUNT(*) FROM NoShows WHERE student_id = ? AND date = ?");
    $checkQuery->bind_param("is", $student_id, $date);
    $checkQuery->execute();
    $checkQuery->bind_result($count);
    $checkQuery->fetch();
    $checkQuery->close();

    if ($count > 0) {
        $error = "This student already has a no-show logged for this date.";
    } else {
        $stmt = $conn->prepare("INSERT INTO NoShows (student_id, date, reason) VALUES (?, ?, ?)");
        $stmt->bind_param("iss", $student_id, $date, $reason);
        if ($stmt->execute()) {
            $stmt->close();
            header("Location: log-noshow.php?success=1");
            exit();
        } else {
            $error = "Error: Could not record no-show.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Log No-Show</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            height: 100vh;
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0,0,0,0.2);
            width: 400px;
            text-align: center;
        }
        label, select, input[type="date"], textarea {
            display: block;
            width: 100%;
            margin-bottom: 15px;
            padding: 8px;
        }
        input[type="submit"], form button {
            padding: 10px 15px;
            margin: 5px;
            background-color: #ff6c2c;
            border: none;
            color: white;
            border-radius: 5px;
            cursor: pointer;
        }
        .success { color: green; }
        .error { color: red; }
    </style>
</head>
<body>
<div class="container">
    <h2>Log a No-Show</h2>

    <?php if ($success): ?>
        <p class="success">No-show recorded successfully.</p>
        <form method="GET">
            <button type="submit">Log Another No-Show</button>
            <button type="button" onclick="window.location.href='instructor-dashboard.php'">Done</button>
        </form>
    <?php elseif ($error): ?>
        <p class="error"><?php echo $error; ?></p>
    <?php endif; ?>

    <?php if (!$success): ?>
        <form method="POST">
            <label for="student_id">Student:</label>
            <select name="student_id" required>
                <option value="">Select a student</option>
                <?php
                $result = $conn->query("SELECT id, first_name, last_name FROM Students ORDER BY last_name, first_name");
                while ($row = $result->fetch_assoc()) {
                    $fullName = htmlspecialchars("{$row['last_name']}, {$row['first_name']}");
                    echo "<option value='{$row['id']}'>{$fullName}</option>";
                }
                ?>
            </select>

            <label for="date">Date:</label>
            <input type="date" name="date" required>

            <label for="reason">Reason:</label>
            <textarea name="reason" placeholder="Optional"></textarea>

            <input type="submit" value="Log No-Show">
        </form>
    <?php endif; ?>
</div>
</body>
</html>



