<?php
session_start();
require 'db.php';

$results = [];
$error = "";

// Determine redirect target
$dashboard = isset($_SESSION['admin_id']) ? 'admin-dashboard.php' : 'instructor-dashboard.php';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $query = trim($_POST['search']);

    if ($query) {
        $like = "%" . $query . "%";
        $stmt = $conn->prepare("
            SELECT first_name, last_name, email, section_code, de964_number, ade1317_number, duplicate_de964, duplicate_ade1317
            FROM Students
            WHERE 
                first_name LIKE ? OR 
                last_name LIKE ? OR 
                email LIKE ? OR 
                section_code LIKE ? OR 
                de964_number LIKE ? OR 
                ade1317_number LIKE ? OR 
                duplicate_de964 LIKE ? OR 
                duplicate_ade1317 LIKE ?
        ");
        $stmt->bind_param("ssssssss", $like, $like, $like, $like, $like, $like, $like, $like);
        $stmt->execute();
        $result = $stmt->get_result();

        while ($row = $result->fetch_assoc()) {
            $results[] = $row;
        }

        if (empty($results)) {
            $error = "No students matched your search.";
        }

        $stmt->close();
    } else {
        $error = "Please enter a name, control number, or section code.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Lookup Student</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f7f7f7;
            padding: 40px;
        }
        .container {
            background: white;
            max-width: 600px;
            margin: auto;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
        }
        h2 { text-align: center; }
        input[type=text], input[type=submit], button {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
        }
        .error { color: red; text-align: center; }
        .student {
            background: #f1f1f1;
            margin-top: 15px;
            padding: 10px;
            border-radius: 6px;
        }
        .buttons {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
        }
        .buttons {
    display: flex;
    justify-content: space-between;
    gap: 10px;
    margin-top: 20px;
}

.buttons button {
    flex: 1;
    background-color: #ff6c2c;
    color: white;
    border: none;
    cursor: pointer;
    border-radius: 5px;
    padding: 10px;
}


.buttons button {
    background-color: #ff6c2c;
    color: white;
    border: none;
    cursor: pointer;
    border-radius: 5px;
    padding: 10px;
}

    </style>
</head>
<body>
<div class="container">
    <h2>Lookup Student</h2>

    <?php if ($error): ?><p class="error"><?= $error ?></p><?php endif; ?>

    <?php if (empty($results)): ?>
        <form method="post">
            <input type="text" name="search" placeholder="Enter name, control #, or section code" required>
            <input type="submit" value="Search">
        </form>
    <?php else: ?>
        <?php foreach ($results as $student): ?>
            <div class="student">
                <p><strong>Name:</strong> <?= htmlspecialchars($student['first_name'] . ' ' . $student['last_name']) ?></p>
                <p><strong>Email:</strong> <?= htmlspecialchars($student['email']) ?></p>
                <p><strong>Section Code:</strong> <?= htmlspecialchars($student['section_code'] ?: 'N/A') ?></p>
                <p><strong>DE-964:</strong> <?= $student['de964_number'] ?: 'N/A' ?></p>
                <p><strong>ADE-1317:</strong> <?= $student['ade1317_number'] ?: 'N/A' ?></p>
                <p><strong>Duplicate DE-964:</strong> <?= $student['duplicate_de964'] ?: 'N/A' ?></p>
                <p><strong>Duplicate ADE-1317:</strong> <?= $student['duplicate_ade1317'] ?: 'N/A' ?></p>
            </div>
        <?php endforeach; ?>
        <div class="buttons">
            <form method="get"><button type="submit">Look Up Another</button></form>
            <?php if (isset($_SESSION['admin_id'])): ?>
    <button type="button" onclick="window.location.href='admin-dashboard.php'">Return to Dashboard</button>
<?php elseif (isset($_SESSION['instructor_id'])): ?>
    <button type="button" onclick="window.location.href='instructor-dashboard.php'">Return to Dashboard</button>
<?php endif; ?>

        </div>
    <?php endif; ?>
</div>
</body>
</html>


