<?php
session_start();
require 'db.php';

if (!isset($_SESSION['admin_id'])) {
    header("Location: admin-login.php");
    exit();
}

$success = "";
$error = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $student_id = $_POST['student_id'] ?? '';
    $de964_number = $_POST['de964_number'] ?? null;
    $ade1317_number = $_POST['ade1317_number'] ?? null;
    $duplicate_de964 = $_POST['duplicate_de964'] ?? null;
    $duplicate_ade1317 = $_POST['duplicate_ade1317'] ?? null;

    // Validation for proper prefix format
    if ($de964_number && !preg_match("/^DE\\d{1,17}$/", $de964_number)) {
        $error = "DE-964 number must begin with 'DE' followed by digits.";
    } elseif ($ade1317_number && !preg_match("/^ADE\\d{1,17}$/", $ade1317_number)) {
        $error = "ADE-1317 number must begin with 'ADE' followed by digits.";
    } elseif ($duplicate_de964 && !preg_match("/^DE\\d{1,17}$/", $duplicate_de964)) {
        $error = "Duplicate DE-964 must begin with 'DE' followed by digits.";
    } elseif ($duplicate_ade1317 && !preg_match("/^ADE\\d{1,17}$/", $duplicate_ade1317)) {
        $error = "Duplicate ADE-1317 must begin with 'ADE' followed by digits.";
    } elseif ($student_id) {
        $stmt = $conn->prepare("UPDATE Students SET de964_number = ?, ade1317_number = ?, duplicate_de964 = ?, duplicate_ade1317 = ? WHERE id = ?");
        $stmt->bind_param("ssssi", $de964_number, $ade1317_number, $duplicate_de964, $duplicate_ade1317, $student_id);
        if ($stmt->execute()) {
            $success = "Certificate details updated successfully.";
        } else {
            $error = "Error updating certificate info.";
        }
        $stmt->close();
    } else {
        $error = "Please select a student.";
    }
}

$students = $conn->query("SELECT id, first_name, last_name FROM Students ORDER BY last_name, first_name");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Update Certificate Info</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; padding: 20px; }
        .container { max-width: 600px; margin: auto; background: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        h2 { text-align: center; }
        label { display: block; margin-top: 10px; }
        select, input[type=text], input[type=submit] {
            width: 100%; padding: 8px; margin-top: 5px; border-radius: 4px; border: 1px solid #ccc;
        }
        .success { color: green; }
        .error { color: red; }
    </style>
</head>
<body>
<div class="container">
    <h2>Update Certificate Control Numbers</h2>
    <?php if ($success): ?><p class="success"><?php echo $success; ?></p><?php endif; ?>
    <?php if ($error): ?><p class="error"><?php echo $error; ?></p><?php endif; ?>

    <form method="post">
        <label for="student_id">Select Student:</label>
        <select name="student_id" required>
            <option value="">-- Choose Student --</option>
            <?php while ($row = $students->fetch_assoc()): ?>
                <option value="<?= $row['id'] ?>">
                    <?= htmlspecialchars($row['last_name'] . ", " . $row['first_name']) ?>
                </option>
            <?php endwhile; ?>
        </select>

        <label for="de964_number">DE-964 Control Number (Teens):</label>
        <input type="text" name="de964_number" placeholder="Enter DE-964 if applicable">

        <label for="ade1317_number">ADE-1317 Control Number (Adults):</label>
        <input type="text" name="ade1317_number" placeholder="Enter ADE-1317 if applicable">

        <label for="duplicate_de964">Duplicate DE-964 Control Number:</label>
        <input type="text" name="duplicate_de964" placeholder="Enter duplicate DE-964 if reissued">

        <label for="duplicate_ade1317">Duplicate ADE-1317 Control Number:</label>
        <input type="text" name="duplicate_ade1317" placeholder="Enter duplicate ADE-1317 if reissued">

        <input type="submit" value="Update Certificate Info">
    </form>
    <form action="admin-dashboard.php" method="get" style="margin-top: 15px;">
    <input type="submit" value="Done" style="background-color: #007bff; color: white;">
</form>

</div>
</body>
</html>

